//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using Server;

namespace Server.Items
{
	public class MinionLordsAxe : ExecutionersAxe
	{
	 	public override int ArtifactRarity{ get{ return 35; } }
	 	public override int InitMinHits{ get{ return 125; } }
	 	public override int InitMaxHits{ get{ return 125; } }
	 	[Constructable]
	 	public MinionLordsAxe()
	 	{
	 	 	Name = "a Minion Lords axe";
	 	 	Hue = 1157;
	 	 	LootType = LootType.Cursed;
	 	 	Attributes.BonusStr = 5;
	 	 	Attributes.RegenHits = 2;
	 	 	Attributes.AttackChance = 10;
	 	 	Attributes.WeaponDamage = 20;
	 	 	Attributes.WeaponSpeed = 25;
	 	 	WeaponAttributes.HitFireArea = 30;
	 	 	WeaponAttributes.SelfRepair = 1;
	 	 	Attributes.CastSpeed = 2;
	 	 	Attributes.CastRecovery = 2;
	 	 	WeaponAttributes.HitFireball = 20;
	 	}

	 	public MinionLordsAxe(Serial serial) : base( serial )
	 	{
	 	}

	 	public override void Serialize( GenericWriter writer )
	 	{
	 	 	base.Serialize( writer );

	 	 	writer.Write( (int) 0 );
	 	}
	 	public override void Deserialize(GenericReader reader)
	 	{
	 	 	base.Deserialize( reader );

	 	 	int version = reader.ReadInt();
	 	}
	}
}
